<?php

declare(strict_types=1);

use Erlage\Photogram\State;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Requests\Post\PostActions;
use Erlage\Photogram\Requests\Post\PostContent;
use Erlage\Photogram\Constants\RequestConstants;
use Erlage\Photogram\Requests\Post\Like\PostLikeActions;
use Erlage\Photogram\Requests\Post\Like\PostLikeContent;
use Erlage\Photogram\Requests\Post\Save\PostSaveActions;
use Erlage\Photogram\Requests\Post\Save\PostSaveContent;
use Erlage\Photogram\Requests\Post\Comment\PostCommentActions;
use Erlage\Photogram\Requests\Post\Comment\PostCommentContent;
use Erlage\Photogram\Requests\Post\Usertag\PostUserTagContent;
use Erlage\Photogram\Requests\Post\Comment\Like\PostCommentLikeActions;
use Erlage\Photogram\Requests\Post\Comment\Like\PostCommentLikeContent;

/*
|--------------------------------------------------------------------------
| Handle request:
|--------------------------------------------------------------------------
*/

switch (State::getReqType())
{
    /*
    |--------------------------------------------------------------------------
    | look for post requests
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_POST_GLOBAL_FEED_LOAD_LATEST:
        PostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_GLOBAL,
            ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST
        );

    break;

    case RequestConstants::REQ_TYPE_POST_GLOBAL_FEED_LOAD_BOTTOM:
        PostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_GLOBAL,
            ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM
        );

    break;

    case RequestConstants::REQ_TYPE_POST_USER_FEED_LOAD_LATEST:
        PostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_SINGLE,
            ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST
        );

    break;

    case RequestConstants::REQ_TYPE_POST_USER_FEED_LOAD_BOTTOM:
        PostContent::load(
            ServerConstants::SERVER_CONST_FEED_TYPE_SINGLE,
            ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM
        );

    break;

    // single content

    case RequestConstants::REQ_TYPE_POST_LOAD_SINGLE: PostContent::loadSingle();

    break;

    // infinite content

    case RequestConstants::REQ_TYPE_POST_INFINITE_LOAD: PostContent::inifinite();

    break;

    // actions

    case RequestConstants::REQ_TYPE_POST_ADD: PostActions::add();

    break;

    case RequestConstants::REQ_TYPE_POST_REMOVE: PostActions::remove();

    break;

    /*
    |--------------------------------------------------------------------------
    | post like
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_POST_LIKE_LOAD_LATEST: PostLikeContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_POST_LIKE_LOAD_BOTTOM: PostLikeContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    // actions

    case RequestConstants::REQ_TYPE_POST_LIKE_ADD: PostLikeActions::add();

    break;

    case RequestConstants::REQ_TYPE_POST_LIKE_REMOVE: PostLikeActions::remove();

    break;

    /*
    |--------------------------------------------------------------------------
    | post comment:
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_POST_COMMENT_LOAD_LATEST: PostCommentContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_POST_COMMENT_LOAD_BOTTOM: PostCommentContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    // actions

    case RequestConstants::REQ_TYPE_POST_COMMENT_ADD: PostCommentActions::add();

    break;

    case RequestConstants::REQ_TYPE_POST_COMMENT_REMOVE: PostCommentActions::remove();

    break;

    /*
    |--------------------------------------------------------------------------
    | post comment like
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_POST_COMMENT_LIKE_LOAD_LATEST: PostCommentLikeContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_POST_COMMENT_LIKE_LOAD_BOTTOM: PostCommentLikeContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    // actions

    case RequestConstants::REQ_TYPE_POST_COMMENT_LIKE_ADD: PostCommentLikeActions::add();

    break;

    case RequestConstants::REQ_TYPE_POST_COMMENT_LIKE_REMOVE: PostCommentLikeActions::remove();

    break;

    /*
    |--------------------------------------------------------------------------
    | post save
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_POST_SAVE_LOAD_LATEST: PostSaveContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_POST_SAVE_LOAD_BOTTOM: PostSaveContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    // actions

    case RequestConstants::REQ_TYPE_POST_SAVE_ADD: PostSaveActions::add();

    break;

    case RequestConstants::REQ_TYPE_POST_SAVE_REMOVE: PostSaveActions::remove();

    break;

    /*
    |--------------------------------------------------------------------------
    | post usertag
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_POST_USER_TAG_LOAD_LATEST: PostUserTagContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_POST_USER_TAG_LOAD_BOTTOM: PostUserTagContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;
}
